<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="">
	<meta name="author" content="Ansonika">
	<title>Reservation Request | AIDA LUXURY VILLAS - ANALIPSI - CHERSONISSOS - CRETE - GREECE</title>
	<?php include_once ('../_gtag.php'); ?>
	
	<!-- Favicons-->
	<link rel="shortcut icon" href="../img/favicon.ico" type="image/x-icon">
	<link rel="apple-touch-icon" type="image/x-icon" href="../img/apple-touch-icon-57x57-precomposed.png">
	<link rel="apple-touch-icon" type="image/x-icon" sizes="72x72" href="../img/apple-touch-icon-72x72-precomposed.png">
	<link rel="apple-touch-icon" type="image/x-icon" sizes="114x114" href="../img/apple-touch-icon-114x114-precomposed.png">
	<link rel="apple-touch-icon" type="image/x-icon" sizes="144x144" href="../img/apple-touch-icon-144x144-precomposed.png">

	<!-- GOOGLE WEB FONT-->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Caveat:wght@400;500&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">

	<!-- BASE CSS -->
	<link href="../css/bootstrap.min.css" rel="stylesheet">
	<link href="../css/style.css" rel="stylesheet">
	<link href="../css/vendors.min.css" rel="stylesheet">

	<!-- YOUR CUSTOM CSS -->
	<link href="../css/custom.css" rel="stylesheet">

	<?php include_once ('../_fbpixel.php'); ?>

</head>

<body class="datepicker_mobile_full"> 

	<?php include_once ('_header.php'); ?>
	
	<main>

		<div class="hero full-height jarallax" data-jarallax data-speed="0.2">
			<img class="jarallax-img" src="../img/header/header-check-in.jpg" alt="Reservation Request">
			<div class="wrapper opacity-mask d-flex align-items-center justify-content-center text-center animate_hero" data-opacity-mask="rgba(0, 0, 0, 0.5)">
				<div class="container">
					<small class="slide-animated one">Aida Luxury Villas</small>
					<h1 class="slide-animated two">Reservation Request </h1>
				</div>
			</div>
		</div>

		<div class="container margin_120_95" id="booking_section">
			<div class="row justify-content-between">
				<div class="col-xl-4">
					<div data-cue="slideInUp">
						<div class="title">
							<small>Aida Luxury Villas</small>
							<h2>Reservation Request</h2>
						</div>
						<p>Please fill in the following form and we will reply to you as soon as possible for availability and price.</p>
						<div class="phone_element no_borders"><a href="tel:+306945493480"><i class="bi bi-telephone"></i><span><em>Info and bookings</em>+30 694 549 3480</span></a></div>
					</div>
				</div>
				<div class="col-xl-7">
					<div data-cue="slideInUp">
						<div id="message-booking"></div>
						<form method="post" action="../reservation.php" id="bookingform" autocomplete="off">
							<div class="booking_wrapper">
								<p id="daterangepicker-result" class="d-none"></p>
								<input type="hidden" id="date_booking" name="date_booking">
								<div id="daterangepicker-embedded-container" class="embedded-daterangepicker clearfix mb-4"></div>
								<div class="row">
									<div class="col-6">
										<div class="qty-buttons mb-3 version_2">
											<input type="button" value="+" class="qtyplus" name="adults_booking">
											<input type="text" name="adults_booking" id="adults_booking" value="" class="qty form-control" placeholder="Adults">
											<input type="button" value="-" class="qtyminus" name="adults_booking">
										</div>
									</div>
									<div class="col-6">
										<div class="mb-3 qty-buttons mb-3 version_2">
											<input type="button" value="+" class="qtyplus" name="childs_booking">
											<input type="text" name="childs_booking" id="childs_booking" value="" class="qty form-control" placeholder="Childs">
											<input type="button" value="-" class="qtyminus" name="childs_booking">
										</div>
									</div>
								</div>
								<!-- / row -->
								<div class="row">
									<div class="col-lg-6">
										<div class="form-group">
											<input type="text" name="name_booking" id="name_booking" class="form-control" placeholder="Name and Last Name">
										</div>
									</div>
									<div class="col-lg-6">
										<div class="form-group">
											<input type="email" name="email_booking" id="email_booking" class="form-control" placeholder="Email">
										</div>
									</div>
								</div>
							</div>
							<p class="text-end mt-4"><input class="btn_1 outline" type="submit" value="Check Now" id="submit-booking"></p>
						</form>
					</div>
				</div>
			</div>
		</div>


	</main>

	<?php include_once ('_footer.php'); ?>

	<script src="../js/common_scripts.js"></script>
	<script src="../js/common_functions.js"></script>
	<script src="../js/datepicker_inline.js"></script>
	<script src="../phpmailer/validate.js"></script>

</body>
</html>