<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="">
	<meta name="author" content="Ansonika">
	<title>EXPLORE CRETE | AIDA LUXURY VILLAS - ANALIPSI - CHERSONISSOS - CRETE - GREECE</title>
	<?php include_once ('../_gtag.php'); ?>
	
	<!-- Favicons-->
	<link rel="shortcut icon" href="../img/favicon.ico" type="image/x-icon">
	<link rel="apple-touch-icon" type="image/x-icon" href="../img/apple-touch-icon-57x57-precomposed.png">
	<link rel="apple-touch-icon" type="image/x-icon" sizes="72x72" href="../img/apple-touch-icon-72x72-precomposed.png">
	<link rel="apple-touch-icon" type="image/x-icon" sizes="114x114" href="../img/apple-touch-icon-114x114-precomposed.png">
	<link rel="apple-touch-icon" type="image/x-icon" sizes="144x144" href="../img/apple-touch-icon-144x144-precomposed.png">

	<!-- GOOGLE WEB FONT-->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Caveat:wght@400;500&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">

	<!-- BASE CSS -->
	<link href="../css/bootstrap.min.css" rel="stylesheet">
	<link href="../css/style.css" rel="stylesheet">
	<link href="../css/vendors.min.css" rel="stylesheet">

	<!-- YOUR CUSTOM CSS -->
	<link href="../css/custom.css" rel="stylesheet">

	<?php include_once ('../_fbpixel.php'); ?>

</head>

<body class="datepicker_mobile_full"> 

	<?php include_once ('_header.php'); ?>

	<main>

		<div class="hero full-height jarallax" data-jarallax data-speed="0.2">
			<img class="jarallax-img" src="../img/header/header-explore.jpg" alt="">
            <div class="wrapper opacity-mask d-flex align-items-center justify-content-center text-center animate_hero" data-opacity-mask="rgba(0, 0, 0, 0.5)">
				<div class="container">
					<small class="slide-animated one">Aida Luxury Villas</small>
					<h1 class="slide-animated two">Explore Crete</h1>
				</div>
			</div>
		</div>

		<div class="container margin_120_95">
			<div class="row justify-content-between align-items-center">
				<div class="col-lg-7">
					<img src="../img/explore/knossos.jpg" alt="Minoan Palace of Knossos" class="img-fluid rounded-img">
				</div>
				<div class="col-lg-5">
					<div class="title">
						<h2>Minoan Palace of Knossos</h2>
					</div>
					<p>Knossos is the largest Bronze Age archaeological site on Crete and is considered Europe's oldest city. The palace of Knossos was undoubtedly the ceremonial and political centre of the Minoan civilization and culture. It appears as a maze of workrooms, living spaces, and storerooms close to a central square. An approximate graphic view of some aspects of Cretan life in the Bronze Age is provided by restorations of the palace's indoor and outdoor murals, as it is also by the decorative motifs of the pottery and the insignia on the seals and sealings.</p>
				</div>
			</div>
		</div>

		<div class="bg_white">
			<div class="container margin_120_95">
				<div class="row justify-content-between align-items-center">
					<div class="col-lg-5">
						<div class="title">
							<h2>Heraklion Archaeological Museum</h2>
						</div>
						<p>The Heraklion Archaeological Museum is one of the largest and most important museums in Greece, and among the most important museums in Europe. It houses representative artefacts from all the periods of Cretan prehistory and history, covering a chronological span of over 5,500 years from the Neolithic period to Roman times. The singularly important Minoan collection contains unique examples of Minoan art, many of them true masterpieces.</p>
					</div>
					<div class="col-lg-7">
						<img src="../img/explore/heraklion-archaeological-museum.jpg" alt="Heraklion Archaeological Museum" class="img-fluid rounded-img">
					</div>
				</div>
			</div>
		</div>



		<div class="container margin_120_95">
			<div class="row justify-content-between align-items-center">
				<div class="col-lg-7">
					<img src="../img/explore/koules-fortress.jpg" alt="Koules Fortress" class="img-fluid rounded-img">
				</div>
				<div class="col-lg-5">
					<div class="title">
						<h2>Koules Fortress</h2>
					</div>
					<p>The "Castello a Mare" is a fortress located at the entrance of the old port of Heraklion, Crete, Greece. It was built by the Republic of Venice in the early 16th century, and is still in good condition today.<br>In 1462, the Venetian Senate approved a programme to improve the fortifications of Candia (Heraklion). The fortress was completed in 1540. In 1630, the fort was armed with 18 cannons on the ground floor, and 25 cannons on the pathway leading to the roof.<br>During the 21-year long Siege of Candia (Heraklion), Ottoman batteries easily neutralized the fort's firepower. The Ottomans eventually took the fort in 1669, after the Venetians surrendered the entire city.<br>The fortress has been restored, and it is now open to the public. Art exhibitions and cultural activities are occasionally held at the fort.</p>
				</div>
			</div>
		</div>

		<div class="bg_white">
			<div class="container margin_120_95">
				<div class="row justify-content-between align-items-center">
					<div class="col-lg-5">
						<div class="title">
							<h2>Heraklion City</h2>
							<p>Heraklion is a coastal city located on the north shore of the island of Crete in Greece. It is the capital and largest city of Crete, as well as one of the country's major urban centers. Heraklion has a long and rich history, having been inhabited since the Neolithic era and playing an important role in ancient Greek, Roman, and Byzantine times. Today, it is a bustling modern city with a mix of old and new architecture, museums, art galleries, shops, restaurants, and bars. The city is also known for its beautiful beaches, clear blue waters, and lively nightlife. Visitors can explore the famous center of the city known as Lions Square with the Morosini Fountain, the Basilica of St. Markos, the Venetian Loggia and St. Titos as well as the Cathedral of Agios Minas the Venetian harbor and fortifications. Heraklion is a vibrant and exciting city that offers something for everyone, whether you are interested in history, culture, or just want to relax and enjoy the Mediterranean atmosphere.</p>
						</div>
					</div>
					<div class="col-lg-7">
						<img src="../img/explore/morosini-fountain.jpg" alt="Heraklion City" class="img-fluid rounded-img">
					</div>
				</div>
			</div>
		</div>

		<div class="container margin_120_95">
			<div class="row justify-content-between align-items-center">
				<div class="col-lg-7">
					<img src="../img/explore/minoan-palace-of-malia.jpg" alt="Minoan Palace of Malia" class="img-fluid rounded-img">
				</div>
				<div class="col-lg-5">
					<div class="title">
						<h2>Minoan Palace of Malia</h2>
					</div>
					<p>Malia Crete is one of the ancient Minoan palaces which testify to the magnificent civilization which grew up on the island. The site is situated about two miles (3 km) to the east of the modern resort of Malia. It has been excavated mainly by the French School of Archaeology since the early 1920's. Because the site was abandoned at the end of the 2nd millennium BC and no one else every used it, there are no other building or other remains to cause confusion.</p>
				</div>
			</div>
		</div>

		<div class="bg_white">
			<div class="container margin_120_95">
				<div class="row justify-content-between align-items-center">
					<div class="col-lg-5">
						<div class="title">
							<h2>Lassithi Plateau</h2>
						</div>
						<p>Lassithi Plateau is a beautiful valley surrounded by mountains and is known for its picturesque windmills. During 50s and 60s the plateau was one of the first wind farms in Europe. There were thousands of windmills that pumped groundwater, to which irrigated their crops by inhabitants. The 18 villages of the plateau is built at the foot of the surrounding mountains, leaving the plain free for cultivation, and connected by a circular road of length 23km.</p>
					</div>
					<div class="col-lg-7">
						<img src="../img/explore/lassithi-plateau.jpg" alt="Lassithi Plateau" class="img-fluid rounded-img">
					</div>
				</div>
			</div>
		</div>

		<div class="container margin_120_95">
			<div class="row justify-content-between align-items-center">
				<div class="col-lg-7">
					<img src="../img/explore/spinalonga.jpg" alt="Spinalonga" class="img-fluid rounded-img">
				</div>
				<div class="col-lg-5">
					<div class="title">
						<h2>Spinalonga</h2>
					</div>
					<p>Spinalonga is an arid and barren rocky islet with an area of 8.5 hectares lying at the mouth of the natural port of Elounda in the Lasithi prefecture of Crete. Due to its strategic location, it was fortified and served a variety of roles and purposes over the centuries. Here, on an island where lepers from Crete and the rest of Greece had been kept in isolation until 1957, a story about love and pain, separation and fear was born.</p>
				</div>
			</div>
		</div>

		<div class="bg_white">
			<div class="container margin_120_95">
				<div class="row justify-content-between align-items-center">
					<div class="col-lg-5">
						<div class="title">
							<h2>Crete Golf Club</h2>
						</div>
						<p>The Crete Golf Club is a championship golf course - the only 18-hole golf course on the island of Crete and one of the most impressive golf courses of the Mediterranean, which holds a unique challenge and a pleasant experience for both golf players and visitors all year round. The golf course has been built to international PGA standards by architect Bob Hunt, a member of the English PGA. Each hole has been constructed separately and in harmony with the surrounding landscape, providing panoramic views of both the mountains of Crete and the Aegean Sea.</p>
					</div>
					<div class="col-lg-7">
						<img src="../img/explore/crete-golf-club.jpg" alt="Crete Golf Club" class="img-fluid rounded-img">
					</div>
				</div>
			</div>
		</div>

		<div class="container margin_120_95">
			<div class="row justify-content-between align-items-center">
				<div class="col-lg-7">
					<img src="../img/explore/cretaquarium.jpg" alt="Cretaquarium" class="img-fluid rounded-img">
				</div>
				<div class="col-lg-5">
					<div class="title">
						<h2>Cretaquarium</h2>
						<p>This is where your experience exploring the Mediterranean sea world begins. Come face to face with hundreds of species and thousands of living organisms. Be fascinated by their behaviour as they reveal the wide variety of shapes, colors, habits and needs of their own world. Learn about them and reflect on what our common future may be.</p>
					</div>
				</div>
			</div>
		</div>

		<div class="bg_white">
			<div class="container margin_120_95">
				<div class="row justify-content-between align-items-center">
					<div class="col-lg-5">
						<div class="title">
							<h2>Labyrinth Park</h2>
						</div>
						<p>The Labyrinth Theme Park is a family destination park with numerous interactive activities and attractions. It is nestled in the scenic hills above the town of Hersonissos in an area of 15 hectares. The main theme of the park is the Labyrinth, but there will be plenty of other things to do as well! Enjoy the variety of video viewings on the Minoan Civilization shown throughout the day in the projector room. Participate in a round of Mini-Golf, or allow the children a turn on the many quad bikes available! There is an Eco-Garden for nature lovers with Cretan aromatic herbs, local fruit and vegetables and many flowering plants, all labeled in many languages.</p>
					</div>
					<div class="col-lg-7">
						<img src="../img/explore/labyrinth-park.jpg" alt="Labyrinth Park" class="img-fluid rounded-img">
					</div>
				</div>
			</div>
		</div>

		<div class="container margin_120_95">
			<div class="row justify-content-between align-items-center">
				<div class="col-lg-7">
					<img src="../img/explore/watercity.jpg" alt="Watercity" class="img-fluid rounded-img">
				</div>
				<div class="col-lg-5">
					<div class="title">
						<h2>Watercity Waterpark</h2>
					</div>
					<p>Watercity Waterpark gives young and old the opportunity to enjoy a holiday full of play, activities, sun & fun, drinks, relaxation and adrenaline. At Watercity Waterpark the enjoyment of the water element is fully maximized! Experience the wide range of watergames and feel like a kid again! Play without fear, feel the coolness and experience unforgettable moments of relaxation!</p>
				</div>
			</div>
		</div>



	</main>

	<?php include_once ('_footer.php'); ?>

	<script src="../js/common_scripts.js"></script>
	<script src="../js/common_functions.js"></script>

</body>
</html>