<!DOCTYPE html>
<html lang="en">

<head>
	<meta charset="utf-8">
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<meta name="description" content="">
	<meta name="author" content="Ansonika">
	<title>AIDA LUXURY VILLAS - ANALIPSI - CHERSONISSOS - CRETE - GREECE</title>
	<?php include_once ('../_gtag.php'); ?>
	
	<!-- Favicons-->
	<link rel="shortcut icon" href="../img/favicon.ico" type="image/x-icon">
	<link rel="apple-touch-icon" type="image/x-icon" href="../img/apple-touch-icon-57x57-precomposed.png">
	<link rel="apple-touch-icon" type="image/x-icon" sizes="72x72" href="../img/apple-touch-icon-72x72-precomposed.png">
	<link rel="apple-touch-icon" type="image/x-icon" sizes="114x114" href="../img/apple-touch-icon-114x114-precomposed.png">
	<link rel="apple-touch-icon" type="image/x-icon" sizes="144x144" href="../img/apple-touch-icon-144x144-precomposed.png">

	<!-- GOOGLE WEB FONT-->
	<link rel="preconnect" href="https://fonts.googleapis.com">
	<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
	<link href="https://fonts.googleapis.com/css2?family=Caveat:wght@400;500&family=Montserrat:wght@300;400;500;600;700&display=swap" rel="stylesheet">

	<!-- BASE CSS -->
	<link href="../css/bootstrap.min.css" rel="stylesheet">
	<link href="../css/style.css" rel="stylesheet">
	<link href="../css/vendors.min.css" rel="stylesheet">

	<!-- YOUR CUSTOM CSS -->
	<link href="../css/custom.css" rel="stylesheet">

	<?php include_once ('../_fbpixel.php'); ?>

</head>

<body class="datepicker_mobile_full"> 

	<?php include_once ('_header.php'); ?>


	<main>

		<div class="hero full-height jarallax" data-jarallax data-speed="0.2">
			<img class="jarallax-img" src="../img/header/header-aida-luxury-villas.jpg" alt="">
			<div class="wrapper opacity-mask d-flex align-items-center  text-center animate_hero" data-opacity-mask="rgba(0, 0, 0, 0.5)">
				<div class="container">
					<div class="row justify-content-center">
						<div class="col-lg-8">
							<small class="slide-animated one">Luxury Experience</small>
							<h1 class="slide-animated two">Aida Villas</h1>
						</div>
					</div>
				</div>
				<div class="mouse_wp slide-animated four">
					<a href="#first_section" class="btn_explore">
						<div class="mouse"></div>
					</a>
				</div>
			</div>
		</div>

		<div class="bg_white" id="first_section">
			<div class="container margin_120_95">
				<div class="row align-items-center justify-content-between">
					<div class="col-lg-5">
						<div class="title">
							<small>Luxury Experience</small>
							<h2>Aida Villas</h2>
						</div>
						<p>Aida Luxury Villas offers two exquisite villas, each measuring 80m2, complete with their own private swimming pool, accommodating up to 5 people in absolute comfort.</p>
						<p>Nestled in the captivating location of Analipsi Chersonissou, these villas are perfectly situated within a leisurely stroll from the mesmerizing sea, as well as a myriad of shops, restaurants, bars, and captivating attractions.</p>
						<p>Beyond the allure of the pool, each villa boasts sunbeds for ultimate relaxation, an inviting outdoor dining area, a meticulously maintained garden, and ample parking space for your convenience.</p> 
					</div>
					<div class="col-lg-6">
						<img src="../img/aida-luxury-villas-01.jpg" alt="Aida Villas" class="img-fluid rounded-img">
					</div>
				</div>
			</div>
		</div>

		<div class="container margin_120_95">
			<div class="row">
				<div class="col-lg-12 text-center">
					<div class="title">
						<h2>Bedrooms & Bathrooms</h2>
					</div>
				</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><i style="font-size: 32px" class="customicon-swimming-pool"></i><br>Bedroom 1:<br>2 Single Beds</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><i style="font-size: 32px" class="customicon-swimming-pool"></i><br>Bedroom 2:<br>2 Single Beds</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><i style="font-size: 32px" class="customicon-swimming-pool"></i><br>Living Room:<br>2 Sofa Beds</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><i style="font-size: 32px" class="customicon-swimming-pool"></i><br>Bathrooms:<br>2</div>
			</div>
			<div class="text-center mt-5"><a class="btn_1 outline" href="facilities.php">View Facilities</a></div>
		</div>

		<?php include_once ('_gallery.php'); ?>

		<div class="container margin_120_95">
			<div class="row">
				<div class="col-lg-12 text-center">
					<div class="title">
						<small>Luxury Experience</small>
						<h2>Main Facilities</h2>
					</div>
				</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><i style="font-size: 32px" class="customicon-swimming-pool"></i><br>Swimming Pool</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><i style="font-size: 32px" class="icon-hotel-condition"></i><br>Air Condition</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><i style="font-size: 32px" class="icon-hotel-wifi"></i><br>Free Wi-Fi</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><i style="font-size: 32px" class="icon-hotel-tv"></i><br>Flat-screen Satellite TV</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><i style="font-size: 32px" class="icon-hotel-patio"></i><br>Fully Equipped Kitchen</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><i style="font-size: 32px" class="customicon-private-parking"></i><br>Free Parking</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><i style="font-size: 32px" class="icon-hotel-hairdryer"></i><br>Hair Dryer</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><i style="font-size: 32px" class="icon-hotel-safety_box"></i><br>Safety Box</div>
			</div>
			<div class="text-center mt-5"><a class="btn_1 outline" href="facilities.php">View All</a></div>
		</div>

		<div class="bg_white" id="first_section">
			<div class="container margin_120_95">
				<div class="row align-items-center justify-content-between">
					<div class="col-lg-5">
						<p>These villas are fully equipped to cater to your every need, including a spacious living room furnished with a satellite flat-screen TV, air-conditioning, and complimentary high-speed Wi-Fi.</p>
						<p>Moreover, the well-appointed kitchen features top-of-the-line amenities, such as a refrigerator, stove, microwave, coffee machine, toaster, and kettle. Accompanied by a generous dining table, it offers the perfect setting for delightful meals shared with your cherished family or friends.</p>
						<p>Lastly, our private bathrooms provide a refreshing shower experience, complete with complimentary toiletries for your comfort and indulgence.</p>
					</div>
					<div class="col-lg-6">
						<img src="../img/aida-luxury-villas-02.jpg" alt="Aida Villas" class="img-fluid rounded-img">
					</div>
				</div>
			</div>
		</div>

		<div class="container margin_120_95">
			<div class="row">
				<div class="col-lg-12 text-center">
					<div class="title">
						<small>Luxury Experience</small>
						<h2>Our Policies</h2>
					</div>
				</div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><h4>Check-in</h4><p>From 15:00 to 00:00</p></div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><h4>Check-out</h4><p>From 08:00 to 11:00</p></div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><h4>Pets</h4><p>Pets are not allowed</p></div>
				<div class="col-12 col-lg-3 text-center" style="padding-bottom:30px; "><h4>Smoking</h4><p>No smoking</p></div>
			</div>
		</div>

	</main>

	<?php include_once ('_footer.php'); ?>

	<script src="../js/common_scripts.js"></script>
	<script src="../js/common_functions.js"></script>
	<script src="js/datepicker_inline.js"></script>
	<script>
	// Progress bars animation
	$(function() {
		"use strict";
		var $section = $('#reviews');
		$(window).on('scroll', function(ev) {
			var scrollOffset = $(window).scrollTop();
			var containerOffset = $section.offset().top - window.innerHeight;
			if (scrollOffset > containerOffset) {
				$(".progress-bar").each(function() {
					var each_bar_width = $(this).attr('aria-valuenow');
					$(this).width(each_bar_width + '%');
				});
			}
		});
	});
</script>

</body>
</html>